var sass = require('./sass.sync.js')
var path = require('path');

sass.options({
  style: sass.style.expanded
});

module.exports = function compile(files) {

	return new Promise((resolve, reject) => {

		sass.clearFiles();
		sass.writeFile(files);

		var response = {};

		var total = 0;
		var current = 0;
		var hasError = false;

		for (let filePath in files) {

			if (/^_/.test(path.basename(filePath))) {
				// SASS partial. Skip compilation.
				continue;
			}

			total++;

			sass.compileFile(filePath, r => {
				
				if (hasError) return;

				if (r.status == 1) {
					// Error
					
					reject({
						short: 'SASS Compilation Error',
						long: r.formatted.replace('Error: ', '').split('\n')[0],
						file: r.file.replace(/^\/sass\//, ''),
						line: r.line,
						column: r.column
					});

					hasError = true;
					return;
				}

				response[filePath] = r.text || '';
				current++;
				
				if (total == current) {
					// All compilations have completed successfully
					resolve(response);
				}
			});
		}

		if (!total) {
			resolve({});
		}

	});

};