var fs = require('fs');
var net = require('net');
var os = require('os');
var path = require('path');

module.exports = function singleInstance(id, cb) {

	var socket = (process.platform === 'win32') ? 
					'\\\\.\\pipe\\'+id+'-sock' : 
					path.join(os.tmpdir(), id+'.sock');

	var client = net.connect({path: socket}, function () {

		client.write(JSON.stringify(process.argv));
		client.end();
		cb(false);

	}).on('error', function (err) {
		
		if (process.platform !== 'win32') {
			// Unlink old unix socket if it exists
			try {
				fs.unlinkSync(socket);
			} catch (e) {
				if (e.code !== 'ENOENT') {
					throw e;
				}
			}
		}

		var listener = cb(true);

		net.createServer(function (con) {
			
			try{
				con.on('data', function(data){
					listener(JSON.parse(data));
					con.end();
				});
			}
			catch(e){
				console.error(e);
			}

		}).on('error', function(err){
			cb(false);
		}).listen(socket);
		
	});
}