
module.exports = function replaceCallbackPointers(arr, sender, eventName) {

	for (var item of arr) {

		for (var key in item) {

			if (Array.isArray(item[key])) {
				replaceCallbackPointers(item[key], sender);
				continue;
			}

			// This is a pointer. Replace it with a callback which sends
			// an ipc request to the bowser window with the cbid.

			if (item[key] && item[key].cbid) {
				item[key] = callback.bind(null, sender, item[key].cbid);
			}
		}
	}
};

function callback(sender, cbid) {
	sender.send('menu-click', cbid);
}
