var fs = require('fs');
var path = require('path');
var crypto = require('crypto');

var electron = require('electron');
var app = electron.app;

module.exports = function(publicKey) {

	var labKey = app.getPath('userData') + path.sep + 'lab.key';

	if (fs.existsSync(labKey)) {
		try {
			var data = JSON.parse(crypto.publicDecrypt(publicKey, fs.readFileSync(labKey)).toString());
			return data.id && data.expires*1000 > Date.now();
		}
		catch(e) {
			console.error(e);
		}
	}

	return false;
};