(function(){

	// Automated error reporting system

	var errors = [];

	window.onerror = function(message, file, line, column, error){

		for (var err of errors) {
			if (err.stack == error.stack) {
				// This error has already occurred.
				err.occurrences++;
				err.lastOccurrence = new Date().toISOString();
				return;
			}
		}

		errors.push({
			message: error.message,
			stack: error.stack,
			occurrences: 1,
			bs_version: app.getVersion(),
			firstOccurrence: new Date().toISOString(),
			lastOccurrence: new Date().toISOString()
		});

	};

	setInterval(function(){

		if (!errors.length) {
			return;
		}

		// Once per minute report all errors to our server

		$.post(app.server + '/app/error-log?token=' + app.plugin.getToken(), {
			errors
		}).done(function(response){

			if(response.status == 'success'){
				errors = [];
			}

		});

	}, 60*1000);

})();