var electron = require('electron');
var app = electron.app;
var ipc = electron.ipcMain;

var {autoUpdater} = require("electron-updater");

module.exports = function initialize(server) {

	var updateTimeout, updateStrategy;

	ipc.on('start-updater', function(event, token, strategy) {
		
		var feedURL = server + '/app/updates';

		if (token) {
			feedURL += '?token=' + token;
		}

		updateStrategy = strategy;

		autoUpdater.autoDownload = false;
		autoUpdater.setFeedURL(feedURL);

		// Check for updates after 30 seconds and every 3 hours thereafter

		updateTimeout = setTimeout(checkForUpdates, 30*1000);

	});

	ipc.on('check-for-updates', checkForUpdates);

	ipc.on('download-update', () => {
		autoUpdater.downloadUpdate().catch(e => console.log(e));
	});

	autoUpdater.on('update-available', (info) => {
		
		// Stop further checks and notify the render process

		clearTimeout(updateTimeout);
		global.browserWindow.webContents.send('update-available', info.version);

		if (updateStrategy != 'confirm') {
			autoUpdater.downloadUpdate().catch(e => console.log(e));
		}

	});

	autoUpdater.on('update-downloaded', info => {
		global.browserWindow.webContents.send('update-downloaded', info.version);
	});
	
	autoUpdater.on('update-not-available', () => {
		global.browserWindow.webContents.send('update-not-available');
	});

	function checkForUpdates(){
		autoUpdater.checkForUpdates().catch(e => console.log(e));
		clearTimeout(updateTimeout);
		updateTimeout = setTimeout(checkForUpdates, 3*60*60*1000);
	}

};
