var EventEmitter = require('events').EventEmitter;
var http = require('http');
var SSE = require('sse');

var electron = require('electron');
var app = electron.app;
var ipc = electron.ipcMain;

module.exports = function initialize(){

	// Register this module as a global, so that the browser window 
	// can initialize it when needed.

	global.createSSEServer = function createSSEServer(id){

		var pubsub = new EventEmitter;
		pubsub.setMaxListeners(0);

		ipc.on(id + '-message', message);

		function message(event, message){
			pubsub.emit(id + '-message', message);
		}

		var server = http.createServer(function(request, response) {
			response.statusCode = 200;
			response.setHeader('Content-Type', 'text/plain');
			response.end('test');
		});

		return {
			start: function(port, ip, cb){

				enableDestroy(server);

				server.listen(port || 0, ip || '0.0.0.0', function(){
					
					var sse = new SSE(server, { path: '/', crossOrigin: '*'});

					sse.on('connection', function(client){

						pubsub.on(id + '-message', handle);

						function handle(msg){
							client.send(JSON.stringify(msg));
						}

						client.on('close', function(){
							pubsub.removeListener(id + '-message', handle);
						});

					});

					global.browserWindow.webContents.send(id + '-listening', server.address());

					if(cb) cb(server.address());
				});
			},
			stop: function(){
				server.destroy(function() {
					ipc.removeListener(id + '-message', message);
				});
			}
		}

	}

	function enableDestroy(server) {
		var connections = {}

		server.on('connection', function(conn) {
			var key = conn.remoteAddress + ':' + conn.remotePort;
			connections[key] = conn;
			conn.on('close', function() {
				delete connections[key];
			});
		});

		server.destroy = function(cb) {
			server.close(cb);
			for (var key in connections) {
				connections[key].destroy();
			}
		};
	}
};