var electron = require('electron');
var app = electron.app;
var ipc = electron.ipcMain;

var child_process = require('child_process');
var fs = require('fs');

module.exports = function initialize() {

	// Used to spawn export scripts

	ipc.on('spawn', function(event, command, path) {

		try {

			var child = child_process.spawn(command, [path]);

			child.on('error', function(err){
				fs.appendFileSync(path + '/error.log', '----------\n\n' + Date().toString() + '\n\nScript ' + command + ' couldn\'t be run\n\n');
			});

			child.stderr.on('data', function(data){
				fs.appendFileSync(path + '/error.log', '----------\n\n' + Date().toString() + '\n\n' + data + '\n\n');
			});
		}
		catch(e){
			fs.appendFileSync(path + '/error.log', '----------\n\n' + Date().toString() + '\n\nCouldn\'t execute script ' + command + '\n\n');
			console.error(e);
		}

	});

	// Spawns external editors

	ipc.on('spawn-editor', function(event, command, path) {

		try {

			var child = null;

			if (process.platform == 'darwin') {
				child = child_process.spawn('open', ['-a', command, path]);
			}
			else {
				child = child_process.spawn(command, [path]);
			}

			child.on('error', e => console.error(e));
		} 
		catch(e){
			console.error(e); 
		}
	});
};
