var electron = require('electron');
var app = electron.app;
var ipc = electron.ipcMain;

module.exports = function initialize() {

	var compile;

	ipc.on('sass-compile', async function(event, data) {

		if (!compile) {
			// Lazily require the sass compiler for faster app startup
			compile = require('studio-sass');
		}

		var message = JSON.parse(data);

		try {

			var result = await compile(message.files);

			output({
				jobID: message.jobID,
				result
			});

		}
		catch (e){

			output({
				status: 'error',
				short: e.short,
				long: e.long || '',
				jobID: message.jobID,
				file: e.file,
				line: e.line,
				column: e.column
			});

		}

	});

	function output(data) {
		global.browserWindow.webContents.send('sass-result', JSON.stringify(data));
	}

}
