var electron = require('electron');
var app = electron.app;
var ipc = electron.ipcMain;

var Menu = electron.Menu;

var replaceCallbackPointers = require('../helpers/replaceCallbackPointers');

module.exports = function initialize() {

	// Used to spawn export scripts

	ipc.on('set-menu', function(event, template) {

		// Replace all "pointers" with a callback
		replaceCallbackPointers(template, event.sender, 'menu-click');

		// Initialize and show the menu
		var menu = Menu.buildFromTemplate(template);
		Menu.setApplicationMenu(menu);
	});
	
};
