var EventEmitter = require('events').EventEmitter;
var http = require('http');
var parse = require('url').parse;

var electron = require('electron');
var app = electron.app;
var ipc = electron.ipcMain;

module.exports = function initialize(){

	// Register this module as a global, so that the browser window 
	// can initialize it when needed.
	
	global.createHTTPServer = function createHTTPServer(id){

		var pubsub = new EventEmitter;
		pubsub.setMaxListeners(0);

		ipc.on(id + '-response', response);

		function response(){
			var event = arguments[0];
			var args = Array.prototype.slice.call(arguments, 1);
			pubsub.emit(args[0], args[1]);
		}

		var server = http.createServer(function(request, response){

			var parsed = parse(request.url, true);

			pubsub.once(parsed.pathname, function(message){
				
				response.statusCode = message.status || 200;

				var headers = message.headers;

				if(!headers){
					headers = {
						'Content-Type': message.contentType || 'text/plain',
						'Cache-Control': 'public; max-age=60',
						'Expires': new Date(Date.now() + 60000).toUTCString(),
					};
				}

				for(var k in headers){
					response.setHeader(k, headers[k]);
				}

				if(message.decode == 'base64'){
					return response.end(Buffer.from(message.content, 'base64'));
				}

				response.end(message.content);
			});

			global.browserWindow.webContents.send(id + '-request', parsed, request.headers);

		});

		return {
			start: function(port, ip, cb){

				enableDestroy(server);

				server.once('error', function(){
					// Likely port is taken. Listen on an automatic port.
					server.listen(0, ip || '0.0.0.0', listening);
				});

				server.listen(port || 0, ip || '0.0.0.0', listening);
				
				function listening(){
					global.browserWindow.webContents.send(id + '-listening', server.address());
					if(cb) cb(server.address());
				}
			},
			stop: function(){
				server.destroy(function() {
					ipc.removeListener(id + '-response', response);
				});
			}
		}

	}

	function enableDestroy(server) {
		var connections = {}

		server.on('connection', function(conn) {
			var key = conn.remoteAddress + ':' + conn.remotePort;
			connections[key] = conn;
			conn.on('close', function() {
				delete connections[key];
			});
		});

		server.destroy = function(cb) {
			server.close(cb);
			for (var key in connections) {
				connections[key].destroy();
			}
		};
	}
};