var electron = require('electron');
var app = electron.app;
var ipc = electron.ipcMain;

var Menu = electron.Menu;

var replaceCallbackPointers = require('../helpers/replaceCallbackPointers');

module.exports = function initialize() {

	// Used to spawn export scripts

	ipc.on('show-context-menu', function(event, options = {}) {

		var template = options.template;

		replaceCallbackPointers(template, event.sender, 'context-menu-click');

		if (template.length) {
			// Initialize and show the menu
			var menu = Menu.buildFromTemplate(template);
			menu.popup();
			menu.once('menu-will-close', (sender) => {

				// If it's not wrapped in a setTimeout,
				// this closes the whole app,
				// supposedly due to some race conditions.

				setTimeout(() => {
					menu.destroy();
				}, 0);
			});
		}

	});
};
