var electron = require('electron');
var app = electron.app;
var session = electron.session;

module.exports = function initialize() {

	var placeholderImage = `file://${__dirname}/../app/assets/img/missing.svg`;

	app.on('ready', function() {

		session.defaultSession.webRequest.onBeforeRequest({
			urls: ['http://bss.design/*']
		},
		(details, callback) => {

			// If a request for bss.design is made, it would indicate that the user has
			// included a non-existant image in Studio. In this case, we just redirect
			// to the local placeholder image.

			callback({
				redirectURL: placeholderImage,
			});
		});

		session.defaultSession.webRequest.onHeadersReceived((details, callback) => {

			if (details.resourceType == 'image' && details.statusCode == 404) {

				// A remote image which couldn't be loaded. Redirect to the placeholder image
				
				callback({
					statusLine: 'HTTP/1.1 302 Found',
					responseHeaders: {
						Location: placeholderImage,
						// Cached for 10 minutes, so that (hopefully) electron doesn't
						// make subsequent requests in that time.
						Expires: new Date(Date.now()+10*60*1000).toUTCString(),
					}
				});

				return;
			}

			callback({});
		});

		session.defaultSession.webRequest.onCompleted({
			urls: ['http://*/*', 'https://*/*']
		},
		details => {

			try {
				// Notify the browser window of this request
				
				global.browserWindow.webContents.send('network-request-completed', [
					details.url,
					details.resourceType,
					details.statusCode
				]);
			}
			catch (e) {}

		});

	});

};